/*
 * Decompiled with CFR 0.152.
 */
package net.ftb.minecraft;

import com.google.common.collect.Lists;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import com.mojang.authlib.UserAuthentication;
import com.mojang.authlib.UserType;
import com.mojang.authlib.properties.PropertyMap;
import com.mojang.authlib.yggdrasil.YggdrasilUserAuthentication;
import com.mojang.util.UUIDTypeAdapter;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.TimeUnit;
import net.feed_the_beast.launcher.json.JsonFactory;
import net.feed_the_beast.launcher.json.OldPropertyMapSerializer;
import net.feed_the_beast.launcher.json.assets.AssetIndex;
import net.ftb.data.ModPack;
import net.ftb.data.Settings;
import net.ftb.data.UserManager;
import net.ftb.log.Logger;
import net.ftb.util.Benchmark;
import net.ftb.util.DownloadUtils;
import net.ftb.util.FileUtils;
import net.ftb.util.OSUtils;
import net.ftb.util.Parallel;

public class MCLauncher {
    public static boolean isLegacy = false;
    private static String separator = File.separator;
    private static String gameDirectory;
    private static StringBuilder cpb;

    public static Process launchMinecraft(String javaPath, String gameFolder, File assetDir, File nativesDir, List<File> classpath, String mainClass, String args, String assetIndex, String rmax, String maxPermSize, String version, UserAuthentication authentication, boolean legacy) throws IOException {
        String additionalEnvVar;
        cpb = new StringBuilder("");
        isLegacy = legacy;
        gameDirectory = gameFolder;
        File gameDir = new File(gameFolder);
        assetDir = MCLauncher.syncAssets(assetDir, assetIndex);
        for (File f : classpath) {
            cpb.append(OSUtils.getJavaDelimiter());
            cpb.append(f.getAbsolutePath());
        }
        if (isLegacy) {
            MCLauncher.setupLegacyStuff(gameDirectory, "MinecraftForge.zip");
        }
        ArrayList<String> arguments = Lists.newArrayList();
        Logger.logInfo("Java Path: " + javaPath);
        Logger.logInfo("Pack: " + ModPack.getSelectedPack().getName() + " " + version);
        arguments.add(javaPath);
        MCLauncher.setMemory(arguments, rmax);
        if (OSUtils.getCurrentOS().equals((Object)OSUtils.OS.WINDOWS) && !OSUtils.is64BitWindows() && (maxPermSize == null || maxPermSize.isEmpty())) {
            if (OSUtils.getOSTotalMemory() > 2046L) {
                maxPermSize = "192m";
                Logger.logInfo("Defaulting PermSize to 192m");
            } else {
                maxPermSize = "128m";
                Logger.logInfo("Defaulting PermSize to 128m");
            }
        }
        if (maxPermSize == null || maxPermSize.isEmpty()) {
            maxPermSize = "256m";
            Logger.logInfo("Defaulting PermSize to 256m");
        }
        arguments.add("-XX:PermSize=" + maxPermSize);
        arguments.add("-Djava.library.path=" + nativesDir.getAbsolutePath());
        arguments.add("-Dorg.lwjgl.librarypath=" + nativesDir.getAbsolutePath());
        arguments.add("-Dnet.java.games.input.librarypath=" + nativesDir.getAbsolutePath());
        arguments.add("-Duser.home=" + gameDir.getParentFile().getAbsolutePath());
        arguments.add("-Djava.net.preferIPv4Stack=true");
        if (Settings.getSettings().getUseSystemProxy().booleanValue()) {
            arguments.add("-Djava.net.useSystemProxies=true");
        }
        arguments.add("-cp");
        arguments.add(cpb.toString());
        String additionalOptions = Settings.getSettings().getAdditionalJavaOptions();
        if (!additionalOptions.isEmpty()) {
            Logger.logInfo("Additional java parameters: " + additionalOptions);
            Collections.addAll(arguments, additionalOptions.split("\\s+"));
        }
        if (Settings.getSettings().getOptJavaArgs()) {
            Logger.logInfo("Adding Optimization Arguments");
            Collections.addAll(arguments, "-XX:+UseParNewGC -XX:+UseConcMarkSweepGC -XX:+CICompilerCountPerCPU -XX:+TieredCompilation".split("\\s+"));
        }
        if ((additionalEnvVar = System.getenv("_JAVA_OPTIONS")) != null && !additionalEnvVar.isEmpty()) {
            Logger.logInfo("_JAVA_OPTIONS defined: " + additionalEnvVar);
        }
        if ((additionalEnvVar = System.getenv("JAVA_TOOL_OPTIONS")) != null && !additionalEnvVar.isEmpty()) {
            Logger.logInfo("JAVA_TOOL_OPTIONS defined: " + additionalEnvVar);
        }
        arguments.add(mainClass);
        for (String s : args.split(" ")) {
            boolean done = false;
            if (authentication.getSelectedProfile() != null) {
                if (s.equals("${auth_player_name}")) {
                    arguments.add(authentication.getSelectedProfile().getName());
                    done = true;
                } else if (s.equals("${auth_uuid}")) {
                    arguments.add(UUIDTypeAdapter.fromUUID((UUID)authentication.getSelectedProfile().getId()));
                    done = true;
                } else if (s.equals("${user_type}")) {
                    arguments.add(authentication.getUserType().getName());
                    done = true;
                }
            } else if (s.equals("${auth_player_name}")) {
                arguments.addAll(UserManager.getNames());
                done = true;
            } else if (s.equals("${auth_uuid}")) {
                arguments.add(new UUID(0L, 0L).toString());
                done = true;
            } else if (s.equals("${user_type}")) {
                arguments.add(UserType.LEGACY.getName());
                done = true;
            }
            if (done) continue;
            if (s.equals("${auth_session}")) {
                if (authentication.isLoggedIn() && authentication.canPlayOnline()) {
                    if (authentication instanceof YggdrasilUserAuthentication && !isLegacy) {
                        arguments.add(String.format("token:%s:%s", authentication.getAuthenticatedToken(), UUIDTypeAdapter.fromUUID((UUID)authentication.getSelectedProfile().getId())));
                        continue;
                    }
                    arguments.add(authentication.getAuthenticatedToken());
                    continue;
                }
                arguments.add("-");
                continue;
            }
            if (s.equals("${auth_access_token}")) {
                arguments.add(authentication.getAuthenticatedToken());
                continue;
            }
            if (s.equals("${version_name}")) {
                arguments.add(version);
                continue;
            }
            if (s.equals("${game_directory}")) {
                arguments.add(gameDir.getAbsolutePath());
                continue;
            }
            if (s.equals("${game_assets}") || s.equals("${assets_root}")) {
                arguments.add(assetDir.getAbsolutePath());
                continue;
            }
            if (s.equals("${assets_index_name}")) {
                arguments.add(assetIndex == null ? "legacy" : assetIndex);
                continue;
            }
            if (s.equals("${user_properties}")) {
                arguments.add(new GsonBuilder().registerTypeAdapter((Type)((Object)PropertyMap.class), new OldPropertyMapSerializer()).create().toJson(authentication.getUserProperties()));
                continue;
            }
            if (s.equals("${user_properties_map}")) {
                arguments.add(new GsonBuilder().registerTypeAdapter((Type)((Object)PropertyMap.class), new PropertyMap.Serializer()).create().toJson(authentication.getUserProperties()));
                continue;
            }
            if (isLegacy) {
                arguments.add(MCLauncher.parseLegacyArgs(s));
                continue;
            }
            arguments.add(s);
        }
        if (!isLegacy) {
            boolean fullscreen = false;
            if (Settings.getSettings().getLastExtendedState() == 6) {
                GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
                Rectangle bounds = env.getMaximumWindowBounds();
                arguments.add("--width");
                arguments.add(String.valueOf((int)bounds.getWidth()));
                arguments.add("--height");
                arguments.add(String.valueOf((int)bounds.getHeight()));
                fullscreen = true;
            }
            Dimension def = new Dimension(854, 480);
            if (Settings.getSettings().getLastDimension().getWidth() != def.getWidth() && !fullscreen) {
                arguments.add("--width");
                arguments.add(String.valueOf((int)Settings.getSettings().getLastDimension().getWidth()));
            }
            if (Settings.getSettings().getLastDimension().getHeight() != def.getHeight() && !fullscreen) {
                arguments.add("--height");
                arguments.add(String.valueOf((int)Settings.getSettings().getLastDimension().getHeight()));
            }
        }
        ProcessBuilder builder = new ProcessBuilder(arguments);
        builder.directory(gameDir);
        builder.redirectErrorStream(true);
        OSUtils.cleanEnvVars(builder.environment());
        return builder.start();
    }

    private static void setMemory(List<String> arguments, String rmax) {
        boolean memorySet = false;
        try {
            int min = 256;
            if (rmax != null && Integer.parseInt(rmax) > 0) {
                arguments.add("-Xms" + min + "M");
                Logger.logInfo("Setting MinMemory to " + min);
                arguments.add("-Xmx" + rmax + "M");
                Logger.logInfo("Setting MaxMemory to " + rmax);
                memorySet = true;
            }
        }
        catch (Exception e) {
            Logger.logError("Error parsing memory settings", e);
        }
        if (!memorySet) {
            arguments.add("-Xms256M");
            Logger.logInfo("Defaulting MinMemory to 256");
            arguments.add("-Xmx1024M");
            Logger.logInfo("Defaulting MaxMemory to 1024");
        }
    }

    private static File syncAssets(File assetDir, String indexName) throws JsonSyntaxException, JsonIOException, IOException {
        Logger.logInfo("Syncing Assets:");
        final File objects = new File(assetDir, "objects");
        AssetIndex index = JsonFactory.loadAssetIndex(new File(assetDir, "indexes/{INDEX}.json".replace("{INDEX}", indexName)));
        if (!index.virtual) {
            return assetDir;
        }
        final File targetDir = new File(assetDir, "virtual/" + indexName);
        final ConcurrentSkipListSet<File> old = new ConcurrentSkipListSet<File>();
        old.addAll(FileUtils.listFiles(targetDir));
        Benchmark.reset("threading");
        Parallel.TaskHandler<Void> th = new Parallel.ForEach(index.objects.entrySet()).withFixedThreads(2 * OSUtils.getNumCores()).apply(new Parallel.F<Map.Entry<String, AssetIndex.Asset>, Void>(){

            @Override
            public Void apply(Map.Entry<String, AssetIndex.Asset> e) {
                AssetIndex.Asset asset = e.getValue();
                File local = new File(targetDir, e.getKey());
                File object = new File(objects, asset.hash.substring(0, 2) + "/" + asset.hash);
                old.remove(local);
                try {
                    if (local.exists() && !DownloadUtils.fileSHA(local).equals(asset.hash)) {
                        Logger.logInfo("  Changed: " + e.getKey());
                        FileUtils.copyFile(object, local, true);
                    } else if (!local.exists()) {
                        Logger.logInfo("  Added: " + e.getKey());
                        FileUtils.copyFile(object, local);
                    }
                }
                catch (Exception ex) {
                    Logger.logError("Asset checking failed: ", ex);
                }
                return null;
            }
        });
        try {
            th.shutdown();
            th.wait(60L, TimeUnit.SECONDS);
        }
        catch (Exception ex) {
            Logger.logError("Asset checking failed: ", ex);
        }
        Benchmark.logBenchAs("threading", "parallel asset(virtual) check");
        for (File f : old) {
            String name = f.getAbsolutePath().replace(targetDir.getAbsolutePath(), "");
            Logger.logInfo("  Removed: " + name.substring(1));
            f.delete();
        }
        return targetDir;
    }

    public static String parseLegacyArgs(String s) {
        if (s.equals("${animation_name}")) {
            return !ModPack.getSelectedPack().getAnimation().equalsIgnoreCase("empty") ? OSUtils.getCacheStorageLocation() + "ModPacks" + separator + ModPack.getSelectedPack().getDir() + separator + ModPack.getSelectedPack().getAnimation() : "empty";
        }
        if (s.equals("${forge_name}")) {
            return "MinecraftForge.zip";
        }
        if (s.equals("${pack_name}")) {
            return ModPack.getSelectedPack().getName() + " v" + (Settings.getSettings().getPackVer().equalsIgnoreCase("recommended version") ? ModPack.getSelectedPack().getVersion() : Settings.getSettings().getPackVer());
        }
        if (s.equals("${pack_image}")) {
            return OSUtils.getCacheStorageLocation() + "ModPacks" + separator + ModPack.getSelectedPack().getDir() + separator + ModPack.getSelectedPack().getLogoName();
        }
        if (s.equals("${extended_state}")) {
            return String.valueOf(Settings.getSettings().getLastExtendedState());
        }
        if (s.equals("${width}")) {
            return String.valueOf(Settings.getSettings().getLastDimension().getWidth());
        }
        if (s.equals("${height}")) {
            return String.valueOf(Settings.getSettings().getLastDimension().getHeight());
        }
        if (s.equals("${minecraft_jar}")) {
            return gameDirectory + File.separator + "bin" + File.separator + "minecraft.jar";
        }
        return s;
    }

    public static void setupLegacyStuff(String workingDir, String forgename) {
        File instModsDir = new File(new File(workingDir).getParentFile(), "instMods/");
        cpb.append(OSUtils.getJavaDelimiter());
        cpb.append(new File(instModsDir, forgename).getAbsolutePath());
        cpb.append(new File(new File(workingDir, "bin"), "minecraft.jar").getAbsolutePath());
        File libsDir = new File(workingDir, "lib/");
        if (libsDir.isDirectory()) {
            Object[] files = libsDir.list();
            Arrays.sort(files);
            for (Object name : files) {
                if (!((String)name).toLowerCase().endsWith(".zip") && !((String)name).toLowerCase().endsWith(".jar")) continue;
                cpb.append(OSUtils.getJavaDelimiter());
                cpb.append(new File(libsDir, (String)name).getAbsolutePath());
            }
        } else {
            Logger.logInfo("Not loading any FML libs, as the directory does not exist.");
        }
    }
}

